; FILE: mdmux.asm                               (D. Tottingham  07/21/89)
;
; to_demux ( sbuffer, dbuffer, bufsize, channelnum )
; unsigned int far * sbuffer;
; unsigned int far * dbuffer;
; unsigned int bufsize;
; int channelnum;
;
; This function demultiplexes the source buffer into the destination buffer,
; where:
;
;       sbuffer         -> far pointer to source buffer
;       dbuffer         -> far pointer to destination buffer
;       bufsize         = size of the source buffer in bytes
;                         size must be a power of two
;       channelnum      = number of channels
;
; NOTE: Source and destination buffers must be a power of two in length.
;       In order to make this a high speed demux routine, bit shifting is
;       involved which forces a bufsize of a power of two in length.
;
; This is a MEDIUM model subroutine.
;

;               include mmdefs.inc              ; memory model definitions

                public  _to_demux

parmdef         struc                           ; stack structure
                dw      ?                       ; old bp
                dd      ?                       ; return address
sbuffer         dd      ?
dbuffer         dd      ?                       ; far pointer
bufsize         dw      ?
channelnum      dw      ?
parmdef         ends

allhi           equ     0FFFFh

_TEXT           segment byte public 'CODE'
                assume cs:_TEXT
_to_demux       proc    far
                push    bp                      ; save old bp
                mov     bp,sp

                push    ds                      ; save registers
                push    es
                push    si
                push    di
                push    ax
                push    bx
                push    cx
                push    dx

                lds     si, [bp].sbuffer        ; pnt to buffers
                les     di, [bp].dbuffer

                sub     si, si                  ; reset si

; generate mask in bx for testing end of buffer
; this mask will have all most significant bits set to 1

                mov     ax, [bp].bufsize        ; save bufsize
                mov     bx, allhi
loop0:          shr     ax, 1
                je      done0
                shl     bx, 1
                jmp short loop0
done0:

; generate mask in dx for resetting source pointer to top of source buffer
; this mask is the one's complement of bx

                mov     dx, bx
                not     dx

; initialize channel counter in cx and mux length in [bp].channelnum

                mov     cx, [bp].channelnum
                add     [bp].channelnum, cx

; cycle channelnum times through the source buffer

loop1:          dec     cx
                jl      done

loop2:          push    si
                add     si, WORD PTR [bp].sbuffer
                mov     ax, [si]
                movsw
                pop     si
                add     si, [bp].channelnum
                test    bx, si
                jz      loop2

; wrap around for another channel

                and     si, dx
                inc     si
                inc     si
                jmp     short loop1

done:           pop     dx
                pop     cx
                pop     bx
                pop     ax
                pop     di
                pop     si
                pop     es
                pop     ds
                pop     bp

                ret
_to_demux       endp

_TEXT           ends
                end
